BITS 32

EXTERN	MMSYSTEM_WAVEOUTRESET$LONGWORD
EXTERN	SYSTEM_MOVE$formal$formal$LONGINT
EXTERN	MMSYSTEM_WAVEOUTPREPAREHEADER$LONGWORD$LPWAVEHDR$LONGWORD
EXTERN	MMSYSTEM_WAVEOUTOPEN$LPHWAVEOUT$LONGWORD$LPCWAVEFORMATEX$LONGWORD$LONGWORD$LONGWORD
EXTERN	MMSYSTEM_WAVEOUTUNPREPAREHEADER$LONGWORD$LPWAVEHDR$LONGWORD
EXTERN	SYSTEM_FILLCHAR$1$formal$LONGINT$CHAR
EXTERN	MMSYSTEM_WAVEOUTWRITE$LONGWORD$LPWAVEHDR$LONGWORD
EXTERN	MMSYSTEM_WAVEOUTCLOSE$LONGWORD

SECTION .text
	ALIGN 4
; [synth.pas]
; [138] END;
	GLOBAL SYNTH_F_POWER$SINGLE$SINGLE
SYNTH_F_POWER$SINGLE$SINGLE:
	GLOBAL F_POWER
F_POWER:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Number located at ebp+8
; Para Exponent located at ebp+12
; [128] FLD Exponent
		fld	dword [ebp+12]
; [129] FLD Number
		fld	dword [ebp+8]
; [130] FYL2X
		fyl2x
; [131] FLD1
		fld1
; [132] FLD ST(1)
		fld	st1
; [133] FPREM
		fprem
; [134] F2XM1
		f2xm1
; [135] FADDP ST(1),ST
		faddp	st1,st0
; [136] FSCALE
		fscale
; [137] FSTP ST(1)
		fstp	st1
		leave
		ret	8
	ALIGN 4
; [142] BEGIN
	GLOBAL SYNTH_WHITENOISERANDOM
SYNTH_WHITENOISERANDOM:
	GLOBAL WhiteNoiseRandom
WhiteNoiseRandom:
; Temps allocated between ebp-8 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,8
; Local $result located at ebp-4
; Local WhiteNoiseValue located at ebp-8
; [143] WhiteNoiseSeed:=(WhiteNoiseSeed*$524281)+$3133731;
		mov	edx,dword [U_SYNTH_WHITENOISESEED]
		mov	eax,5390977
		mul	edx
		add	eax,51590961
		mov	dword [U_SYNTH_WHITENOISESEED],eax
; [144] WhiteNoiseValue:=(WhiteNoiseSeed AND $7FFFFF) OR $40000000;
		and	eax,8388607
		or	eax,1073741824
		mov	dword [ebp-8],eax
; [145] RESULT:=SINGLE(POINTER(@WhiteNoiseValue)^)-3;
		lea	eax,[ebp-8]
		fld	dword [eax]
		fld	tword [..@54]
		fsubp	st1,st0
		fstp	dword [ebp-4]
; [146] END;
		fld	dword [ebp-4]
		leave
		ret
	ALIGN 4
; [150] BEGIN
	GLOBAL SYNTH_FRAC$SINGLE
SYNTH_FRAC$SINGLE:
	GLOBAL FRAC
FRAC:
; Temps allocated between ebp-16 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,16
		mov	dword [ebp-16],esi
		mov	dword [ebp-12],edi
; Para X located at ebp+8
; Local $result located at ebp-4
; Local Y located at ebp-8
; [151] Y:=X;
		lea	edi,[ebp-8]
		lea	esi,[ebp+8]
		cld
		mov	ecx,4
		rep
		movsb
; [153] FLD DWORD PTR Y
		fld	dword [ebp-8]
; [154] FRNDINT
		frndint
; [155] FSTP DWORD PTR Y
		fstp	dword [ebp-8]
; [157] RESULT:=X-Y;
		fld	dword [ebp-8]
		fsubr	dword [ebp+8]
		fstp	dword [ebp-4]
; [158] END;
		fld	dword [ebp-4]
		mov	esi,dword [ebp-16]
		mov	edi,dword [ebp-12]
		leave
		ret	4
	ALIGN 4
; [162] BEGIN
	GLOBAL SYNTH_SYNTHREINIT$T4KSYNTHDATA
SYNTH_SYNTHREINIT$T4KSYNTHDATA:
	GLOBAL SynthReinit
SynthReinit:
; Temps allocated between ebp-16 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,16
		mov	dword [ebp-16],ebx
		mov	dword [ebp-12],esi
		mov	dword [ebp-8],edi
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [163] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
..@65:
		inc	dword [ebp-4]
; [164] SynthData.RealtimeData.EventOffset[Channel]:=SynthData.RealtimeData.RestartEventOffset[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-4]
		lea	edi,[ebx+ecx*4+2099416]
		lea	esi,[ebx+ecx*4+2099608]
		cld
		mov	ecx,4
		rep
		movsb
; [165] SynthData.RealtimeData.NoteOffset[Channel]:=SynthData.RealtimeData.RestartNoteOffset[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-4]
		lea	edi,[ebx+ecx*4+2099480]
		lea	esi,[ebx+ecx*4+2099672]
		cld
		mov	ecx,4
		rep
		movsb
; [166] SynthData.RealtimeData.VolumeOffset[Channel]:=SynthData.RealtimeData.RestartVolumeOffset[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-4]
		lea	edi,[ebx+ecx*4+2099544]
		lea	esi,[ebx+ecx*4+2099736]
		cld
		mov	ecx,4
		rep
		movsb
; [167] SynthData.RealtimeData.TickCounter[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		mov	dword [edx+eax*4+2099352],0
		cmp	eax,15
		jl	NEAR ..@65
; [169] SynthData.RealtimeData.ShouldExit:=TRUE;
		mov	byte [edx+2099808],1
; [170] END;
		mov	ebx,dword [ebp-16]
		mov	esi,dword [ebp-12]
		mov	edi,dword [ebp-8]
		leave
		ret	4
	ALIGN 4
; [173] BEGIN
	GLOBAL SYNTH_SYNTHRECALCFILTER$T4KFILTER
SYNTH_SYNTHRECALCFILTER$T4KFILTER:
	GLOBAL SynthRecalcFilter
SynthRecalcFilter:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Filter located at ebp+8
; [174] WITH Filter DO BEGIN
		mov	eax,dword [ebp+8]
; [175] FBLP:=RLP+RLP/(1-CLP);
		fld	dword [eax+32]
		fld	dword [eax+32]
		fld	dword [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
		fstp	dword [eax+16]
; [176] FBHP:=RHP+RHP/(1-CLP);
		fld	dword [eax+36]
		fld	dword [eax+36]
		fld	dword [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
		fstp	dword [eax+20]
; [178] END;
		leave
		ret	4
	ALIGN 4
; [182] BEGIN
	GLOBAL SYNTH_SYNTHINITDATA$T4KSYNTHDATA
SYNTH_SYNTHINITDATA$T4KSYNTHDATA:
	GLOBAL SynthInitData
SynthInitData:
; Temps allocated between ebp-12 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,12
		mov	dword [ebp-12],esi
		mov	dword [ebp-8],edi
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [183] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
..@88:
		inc	dword [ebp-4]
; [184] IF SynthData.FileData.EventOffset[Channel]>0 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		mov	eax,dword [edx+eax*4+368]
		test	eax,eax
		jng	NEAR ..@92
; [185] SynthData.RealtimeData.RestartEventOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.EventOffset[Channel]));
		mov	ecx,dword [ebp-4]
		mov	eax,edx
		add	eax,dword [edx+ecx*4+368]
		mov	dword [edx+ecx*4+2099608],eax
; [186] SynthData.RealtimeData.RestartNoteOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.NoteOffset[Channel]));
		mov	eax,edx
		add	eax,dword [edx+ecx*4+432]
		mov	dword [edx+ecx*4+2099672],eax
; [187] SynthData.RealtimeData.RestartVolumeOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.VolumeOffset[Channel]));
		mov	eax,edx
		add	eax,dword [edx+ecx*4+496]
		mov	dword [edx+ecx*4+2099736],eax
..@92:
; [189] SynthData.RealtimeData.Filter[Channel].CLP:=CutOffLowPassStartValue;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		imul	eax,40
		lea	edi,[edx+eax+2098728]
		mov	esi,dword ..@101
		cld
		mov	ecx,4
		rep
		movsb
; [190] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		cmp	dword [ebp-4],15
		jl	NEAR ..@88
; [192] SynthReinit(SynthData);
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
; [193] SynthData.RealtimeData.ShouldExit:=FALSE;
		mov	eax,dword [ebp+8]
		mov	byte [eax+2099808],0
; [194] END;
		mov	esi,dword [ebp-12]
		mov	edi,dword [ebp-8]
		leave
		ret	4
	ALIGN 4
; [197] BEGIN
	GLOBAL SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT
SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT:
	GLOBAL SynthCalcNote
SynthCalcNote:
; Temps allocated between ebp-12 and ebp+0
		push	ebp
		mov	ebp,esp
		sub	esp,12
		mov	dword [ebp-12],ebx
		mov	dword [ebp-8],esi
; Para SynthData located at ebp+8
; Para Channel located at ebp+12
; Para Note located at ebp+16
; [198] SynthData.RealtimeData.PhaseIncrement[Channel]:=F_POWER(2,(Note-45)*Div12)*SampleRateFactor;
		mov	esi,dword [ebp+8]
		mov	ebx,dword [ebp+12]
		mov	eax,dword [ebp+16]
		sub	eax,45
		mov	dword [ebp-4],eax
		fild	dword [ebp-4]
		fld	tword [..@114]
		fmulp	st1,st0
		sub	esp,4
		fstp	dword [esp]
		push	dword [..@117]
		call	NEAR SYNTH_F_POWER$SINGLE$SINGLE
		fld	tword [..@118]
		fmulp	st1,st0
		fstp	dword [esi+ebx*4+2098576]
; [199] END;
		mov	ebx,dword [ebp-12]
		mov	esi,dword [ebp-8]
		leave
		ret	12
	ALIGN 4
; [206] BEGIN
	GLOBAL SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE$LONGINT$LONGINT
SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE$LONGINT$LONGINT:
	GLOBAL SynthFillBuffer
SynthFillBuffer:
; Temps allocated between ebp-76 and ebp-48
		push	ebp
		mov	ebp,esp
		sub	esp,76
		mov	dword [ebp-76],ebx
		mov	dword [ebp-72],esi
		mov	dword [ebp-68],edi
; Para SynthData located at ebp+8
; Para Buffer located at ebp+12
; Para StartPosition located at ebp+16
; Para BufferSize located at ebp+20
; Local Position located at ebp-4
; Local Channel located at ebp-8
; Local Count located at ebp-12
; Local WaveForm located at ebp-16
; Local Phase located at ebp-20
; Local Left located at ebp-24
; Local Right located at ebp-28
; Local PanningValue located at ebp-32
; Local OscValue located at ebp-36
; Local Value located at ebp-40
; Local Note located at ebp-44
; Local Volume located at ebp-48
; [207] FOR Position:=0 TO BufferSize-1 DO BEGIN
		mov	eax,dword [ebp+20]
		dec	eax
		mov	dword [ebp-52],eax
		mov	eax,0
		mov	dword [ebp-4],eax
		cmp	eax,dword [ebp-52]
		jg	NEAR ..@166
		dec	dword [ebp-4]
..@167:
		inc	dword [ebp-4]
; [208] Count:=Max4kChannels;
		mov	dword [ebp-12],16
; [209] Left:=0;
		fldz
		fstp	dword [ebp-24]
; [210] Right:=0;
		fldz
		fstp	dword [ebp-28]
; [211] FILLCHAR(SynthData.RealtimeData.LinkFirst,16,#1);
		mov	cl,1
		mov	edx,16
		mov	eax,dword [ebp+8]
		add	eax,2097984
		call	NEAR SYSTEM_FILLCHAR$1$formal$LONGINT$CHAR
; [212] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-8],0
		dec	dword [ebp-8]
..@184:
		inc	dword [ebp-8]
; [213] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
		mov	eax,dword [ebp+8]
		mov	eax,dword [eax+2099804]
		test	eax,eax
		jne	NEAR ..@188
; [214] WHILE ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) AND (SynthData.RealtimeData.TickCounter[Channel]>=SynthData.RealtimeData.EventOffset[Channel]^) DO BEGIN
		jmp	NEAR ..@190
..@189:
; [215] SynthData.RealtimeData.TickCounter[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2099352],0
; [216] Note:=SynthData.RealtimeData.NoteOffset[Channel]^;
		mov	esi,dword [edx+eax*4+2099480]
		lea	edi,[ebp-44]
		cld
		mov	ecx,1
		rep
		movsb
; [217] Volume:=SynthData.RealtimeData.VolumeOffset[Channel]^;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	esi,dword [edx+eax*4+2099544]
		lea	edi,[ebp-48]
		cld
		mov	ecx,1
		rep
		movsb
; [218] INC(SynthData.RealtimeData.EventOffset[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		inc	dword [edx+eax*4+2099416]
; [219] INC(SynthData.RealtimeData.NoteOffset[Channel]);
		inc	dword [edx+eax*4+2099480]
; [220] INC(SynthData.RealtimeData.VolumeOffset[Channel]);
		inc	dword [edx+eax*4+2099544]
; [221] IF (Note<>0) AND (Note<=$81) THEN BEGIN
		mov	ecx,eax
		movzx	eax,byte [ebp-44]
		test	eax,eax
		je	NEAR ..@199
		cmp	eax,129
		jnle	NEAR ..@199
; [222] IF Note<$80 THEN BEGIN
		cmp	eax,128
		jnl	NEAR ..@202
; [223] SynthData.RealtimeData.LastLeft:=SynthData.RealtimeData.LastLeft+SynthData.RealtimeData.ChannelLastLeft[Channel];
		fld	dword [edx+2099344]
		fadd	dword [edx+ecx*4+2098256]
		fstp	dword [edx+2099344]
; [224] SynthData.RealtimeData.LastRight:=SynthData.RealtimeData.LastRight+SynthData.RealtimeData.ChannelLastRight[Channel];
		fld	dword [edx+2099348]
		fadd	dword [edx+ecx*4+2098320]
		fstp	dword [edx+2099348]
; [225] SynthData.RealtimeData.ChannelLastLeft[Channel]:=0;
		fldz
		fstp	dword [edx+ecx*4+2098256]
; [226] SynthData.RealtimeData.ChannelLastRight[Channel]:=0;
		fldz
		fstp	dword [edx+ecx*4+2098320]
; [227] SynthCalcNote(SynthData,Channel,Note);
		push	eax
		push	ecx
		mov	eax,edx
		push	eax
		call	NEAR SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT
; [228] SynthData.RealtimeData.PhaseFactor[Channel]:=SynthData.FileData.StartPhaseFactor[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2098640]
		lea	esi,[ecx+ebx*4+288]
		cld
		mov	ecx,4
		rep
		movsb
; [229] SynthData.RealtimeData.Volume[Channel]:=SynthData.FileData.StartVolume[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2098064]
		lea	esi,[ecx+ebx*4+160]
		cld
		mov	ecx,4
		rep
		movsb
; [230] SynthData.RealtimeData.VolumeFactor[Channel]:=SynthData.FileData.StartVolumeFactor[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		lea	edi,[ebx+ecx*4+2098192]
		lea	esi,[ebx+ecx*4+224]
		cld
		mov	ecx,4
		rep
		movsb
; [231] SynthData.RealtimeData.ADSRMode[Channel]:=1;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098384],1
; [232] SynthData.RealtimeData.ADSRValue[Channel]:=0;
		fldz
		fstp	dword [edx+eax*4+2098448]
		jmp	NEAR ..@227
..@202:
; [233] END ELSE IF Note=$80 THEN BEGIN
		movzx	eax,byte [ebp-44]
		cmp	eax,128
		jne	NEAR ..@229
; [234] SynthData.RealtimeData.ADSRMode[Channel]:=4;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098384],4
..@229:
..@227:
; [236] IF Volume<=64 THEN BEGIN
		movzx	eax,byte [ebp-48]
		cmp	eax,64
		jnle	NEAR ..@237
; [237] SynthData.RealtimeData.VolumeValue[Channel]:=Volume*Div64;
		mov	ecx,dword [ebp+8]
		mov	edx,dword [ebp-8]
		mov	dword [ebp-56],eax
		fild	dword [ebp-56]
		fld	tword [..@236]
		fmulp	st1,st0
		fstp	dword [ecx+edx*4+2098128]
..@233:
		jmp	NEAR ..@237
..@199:
; [240] Value:=Volume*Div256;
		movzx	eax,byte [ebp-48]
		mov	dword [ebp-56],eax
		fild	dword [ebp-56]
		fld	tword [..@240]
		fmulp	st1,st0
		fstp	dword [ebp-40]
; [241] CASE Note OF
		mov	al,byte [ebp-44]
		cmp	al,130
		jb	NEAR ..@242
		cmp	al,147
		ja	NEAR ..@242
		movzx	eax,al
		jmp	[..@243+eax*4-520]
..@142:
; [269] SynthData.RealtimeData.RestartEventOffset[Channel]:=SynthData.RealtimeData.EventOffset[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2099608]
		lea	esi,[ecx+ebx*4+2099416]
		cld
		mov	ecx,4
		rep
		movsb
; [270] SynthData.RealtimeData.RestartNoteOffset[Channel]:=SynthData.RealtimeData.NoteOffset[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		lea	edi,[ebx+ecx*4+2099672]
		lea	esi,[ebx+ecx*4+2099480]
		cld
		mov	ecx,4
		rep
		movsb
; [271] SynthData.RealtimeData.RestartVolumeOffset[Channel]:=SynthData.RealtimeData.VolumeOffset[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		lea	edi,[ebx+ecx*4+2099736]
		lea	esi,[ebx+ecx*4+2099544]
		cld
		mov	ecx,4
		rep
		movsb
		jmp	NEAR ..@241
..@140:
; [267] $92:SynthCalcNote(SynthData,Channel,Volume);
		movzx	eax,byte [ebp-48]
		push	eax
		push	dword [ebp-8]
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT
		jmp	NEAR ..@241
..@138:
; [266] $91:SynthData.RealTimeData.Phase[Channel]:=Value*2*PI;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [ebp-40]
		fld	tword [..@258]
		fmulp	st1,st0
		fldpi
		fmulp	st1,st0
		fstp	dword [edx+eax*4+2098512]
		jmp	NEAR ..@241
..@136:
; [263] SynthData.RealtimeData.Filter[Channel].RHP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098740]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
; [264] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		jmp	NEAR ..@241
..@134:
; [259] SynthData.RealtimeData.Filter[Channel].RLP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098736]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
; [260] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		jmp	NEAR ..@241
..@132:
; [255] SynthData.RealtimeData.Filter[Channel].CHP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098732]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
; [256] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		jmp	NEAR ..@241
..@130:
; [251] SynthData.RealtimeData.Filter[Channel].CLP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098728]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
; [252] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		jmp	NEAR ..@241
..@128:
; [249] $86:SynthData.FileData.Panning[Channel]:=Volume;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		lea	edi,[edx+eax*1+352]
		lea	esi,[ebp-48]
		cld
		mov	ecx,1
		rep
		movsb
		jmp	NEAR ..@241
..@125:
; [245] OscValue:=Volume*PortamentoFactor;
		movzx	eax,byte [ebp-48]
		mov	dword [ebp-56],eax
		fild	dword [ebp-56]
		fld	tword [..@279]
		fmulp	st1,st0
		fstp	dword [ebp-36]
; [246] IF Note=$84 THEN OscValue:=-OscValue;
		movzx	eax,byte [ebp-44]
		cmp	eax,132
		jne	NEAR ..@281
		fld	dword [ebp-36]
		fchs
		fstp	dword [ebp-36]
..@281:
; [247] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*(1+OscValue);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098576]
		fld1
		fadd	dword [ebp-36]
		fmulp	st1,st0
		fstp	dword [edx+eax*4+2098576]
		jmp	NEAR ..@241
..@123:
; [243] $83:SynthData.RealtimeData.EventOffset[Channel]:=NIL;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2099416],0
		jmp	NEAR ..@241
..@121:
; [242] $82:SynthData.RealtimeData.BPMSamples:=(SampleRate*5*128) DIV (Volume SHL 8);
		movzx	ecx,byte [ebp-48]
		shl	ecx,8
		mov	eax,28224000
		mov	edx,0
		div	ecx
		mov	edx,dword [ebp+8]
		mov	dword [edx+2099800],eax
..@242:
..@241:
..@237:
..@190:
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		cmp	dword [edx+eax*4+2099416],0
		je	NEAR ..@191
		mov	ecx,dword [edx+eax*4+2099416]
		movzx	ecx,byte [ecx]
		cmp	ecx,dword [edx+eax*4+2099352]
		jle	NEAR ..@189
..@191:
; [276] IF NOT ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) THEN DEC(Count);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		cmp	dword [edx+eax*4+2099416],0
		jne	NEAR ..@292
..@291:
		dec	dword [ebp-12]
..@292:
; [277] INC(SynthData.RealtimeData.TickCounter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		inc	dword [edx+eax*4+2099352]
..@188:
; [279] Phase:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.LinkValues[Channel]);
		mov	edx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		fld	dword [edx+ecx*4+2098000]
		fadd	dword [edx+ecx*4+2098512]
		sub	esp,4
		fstp	dword [esp]
		call	NEAR SYNTH_FRAC$SINGLE
		fstp	dword [ebp-20]
; [280] WaveForm:=SynthData.FileData.WaveForm[Channel];
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		movzx	eax,byte [edx+eax*1]
		mov	dword [ebp-16],eax
; [281] CASE WaveForm OF
		test	eax,eax
		jl	NEAR ..@300
		cmp	eax,5
		jg	NEAR ..@300
		jmp	[..@301+eax*4]
..@153:
; [290] 5:OscValue:=WhiteNoiseRandom; // White Noise
		call	NEAR SYNTH_WHITENOISERANDOM
		fstp	dword [ebp-36]
		jmp	NEAR ..@299
..@150:
; [289] 3,4:OscValue:=((Phase-0.5)*2)*INTEGER(1-((WaveForm-3)*2)); // Sawtooth Up/Down
		mov	eax,dword [ebp-16]
		sub	eax,3
		shl	eax,1
		mov	edx,1
		sub	edx,eax
		mov	dword [ebp-56],edx
		fild	dword [ebp-56]
		fld	dword [ebp-20]
		fld	tword [..@306]
		fsubp	st1,st0
		fld	tword [..@258]
		fmulp	st1,st0
		fmulp	st1,st0
		fstp	dword [ebp-36]
		jmp	NEAR ..@299
..@148:
; [285] Phase:=Phase-0.5;
		fld	dword [ebp-20]
		fld	tword [..@306]
		fsubp	st1,st0
		fstp	dword [ebp-20]
; [286] OscValue:=LONGWORD((PhaseCasted SHR 31) SHL 1);
		mov	eax,dword [ebp-20]
		shr	eax,31
		shl	eax,1
		mov	dword [ebp-56],eax
		mov	dword [ebp-64],eax
		mov	dword [ebp-60],0
		fild	qword [ebp-64]
		fstp	dword [ebp-36]
; [287] OscValue:=1-OscValue;
		fld1
		fsub	dword [ebp-36]
		fstp	dword [ebp-36]
		jmp	NEAR ..@299
..@146:
; [283] 1:OscValue:=ABS((Phase-0.5)*4)-1; // Triangle
		fld	dword [ebp-20]
		fld	tword [..@306]
		fsubp	st1,st0
		fld	tword [..@315]
		fmulp	st1,st0
		fabs
		fld1
		fsubp	st1,st0
		fstp	dword [ebp-36]
		jmp	NEAR ..@299
..@144:
; [282] 0:OscValue:=SIN(Phase*2*PI); // Sinus
		fld	dword [ebp-20]
		fld	tword [..@258]
		fmulp	st1,st0
		fldpi
		fmulp	st1,st0
		fsin
		fstp	dword [ebp-36]
		jmp	NEAR ..@299
..@300:
; [291] ELSE OscValue:=0; // Nothing ;-)
		fldz
		fstp	dword [ebp-36]
..@299:
; [293] OscValue:=OscValue*SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeValue[Channel]*SynthData.RealtimeData.ADSRValue[Channel];
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [ebp-36]
		fmul	dword [edx+eax*4+2098064]
		fmul	dword [edx+eax*4+2098128]
		fmul	dword [edx+eax*4+2098448]
		fstp	dword [ebp-36]
; [294] WITH SynthData.RealtimeData.Filter[Channel] DO BEGIN
		imul	eax,40
		lea	eax,[edx+eax+2098704]
; [295] FD1:=FD1+CLP*(OscValue-FD1+FBLP*(FD1-FD2));
		fld	dword [eax+4]
		fsubr	dword [eax]
		fmul	dword [eax+16]
		fld	dword [ebp-36]
		fsub	dword [eax]
		faddp	st1,st0
		fmul	dword [eax+24]
		fadd	dword [eax]
		fstp	dword [eax]
; [296] FD2:=FD2+CLP*(FD1-FD2);
		fld	dword [eax+4]
		fsubr	dword [eax]
		fmul	dword [eax+24]
		fadd	dword [eax+4]
		fstp	dword [eax+4]
; [297] FD3:=FD3+CHP*(FD2-FD3+FBHP*(FD3-FD4));
		fld	dword [eax+8]
		fsubr	dword [eax+4]
		fld	dword [eax+12]
		fsubr	dword [eax+8]
		fmul	dword [eax+20]
		faddp	st1,st0
		fmul	dword [eax+28]
		fadd	dword [eax+8]
		fstp	dword [eax+8]
; [298] FD4:=FD4+CHP*(FD3-FD4);
		fld	dword [eax+12]
		fsubr	dword [eax+8]
		fmul	dword [eax+28]
		fadd	dword [eax+12]
		fst	dword [eax+12]
; [299] OscValue:=FD2-FD4;
		fsubr	dword [eax+4]
		fstp	dword [ebp-36]
; [301] CASE SynthData.RealtimeData.ADSRMode[Channel] OF
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*4+2098384]
		test	eax,eax
		jl	NEAR ..@335
		cmp	eax,4
		jg	NEAR ..@335
		jmp	[..@336+eax*4]
..@163:
; [327] IF SynthData.RealtimeData.ADSRValue[Channel]>0 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098448]
		fldz
		fcompp
		mov	ecx,eax
		fnstsw	ax
		sahf
		jnb	NEAR ..@338
; [328] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.ReleaseStep[Channel];
		fld	dword [edx+ecx*4+768]
		fadd	dword [edx+ecx*4+2098448]
		fstp	dword [edx+ecx*4+2098448]
		jmp	NEAR ..@334
..@338:
; [330] SynthData.RealtimeData.ADSRMode[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098384],0
		jmp	NEAR ..@334
..@161:
		jmp	NEAR ..@334
..@159:
; [313] IF SynthData.RealtimeData.ADSRValue[Channel]>SynthData.ADSRData.DestDecay[Channel] THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		fld	dword [edx+ecx*4+688]
		fld	dword [edx+ecx*4+2098448]
		fcompp
		fnstsw	ax
		sahf
		jna	NEAR ..@345
; [314] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.DecayStep[Channel];
		fld	dword [edx+ecx*4+624]
		fadd	dword [edx+ecx*4+2098448]
		fstp	dword [edx+ecx*4+2098448]
		jmp	NEAR ..@334
..@345:
; [316] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.ADSRData.DestDecay[Channel];
		mov	ebx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		lea	edi,[ebx+ecx*4+2098448]
		lea	esi,[ebx+ecx*4+688]
		cld
		mov	ecx,4
		rep
		movsb
; [317] IF SynthData.ADSRData.Sustain[Channel] THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		cmp	byte [edx+eax*1+752],0
		je	NEAR ..@352
; [318] SynthData.RealtimeData.ADSRMode[Channel]:=3;
		mov	dword [edx+eax*4+2098384],3
		jmp	NEAR ..@334
..@352:
; [320] SynthData.RealtimeData.ADSRMode[Channel]:=4;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098384],4
		jmp	NEAR ..@334
..@157:
; [305] IF SynthData.RealtimeData.ADSRValue[Channel]<1 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098448]
		fld1
		fcompp
		mov	ebx,eax
		fnstsw	ax
		sahf
		jna	NEAR ..@359
; [306] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.AttackStep[Channel];
		fld	dword [edx+ebx*4+560]
		fadd	dword [edx+ebx*4+2098448]
		fstp	dword [edx+ebx*4+2098448]
		jmp	NEAR ..@334
..@359:
; [308] SynthData.RealtimeData.ADSRValue[Channel]:=1;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld1
		fstp	dword [edx+eax*4+2098448]
; [309] SynthData.RealtimeData.ADSRMode[Channel]:=2;
		mov	dword [edx+eax*4+2098384],2
..@155:
..@335:
..@334:
; [334] IF SynthData.RealtimeData.ADSRValue[Channel]<0 THEN SynthData.RealtimeData.ADSRValue[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098448]
		fldz
		fcompp
		fnstsw	ax
		sahf
		jna	NEAR ..@368
		mov	eax,dword [ebp-8]
		fldz
		fstp	dword [edx+eax*4+2098448]
..@368:
; [335] IF SynthData.RealtimeData.ADSRValue[Channel]>1 THEN SynthData.RealtimeData.ADSRValue[Channel]:=1;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098448]
		fld1
		fcompp
		fnstsw	ax
		sahf
		jnb	NEAR ..@372
		mov	eax,dword [ebp-8]
		fld1
		fstp	dword [edx+eax*4+2098448]
..@372:
; [336] IF (SynthData.FileData.Link[Channel] AND $7F)<Max4kChannels THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,127
		cmp	eax,16
		jnl	NEAR ..@376
; [337] IF SynthData.RealtimeData.LinkFirst[SynthData.FileData.Link[Channel] AND $7F] THEN BEGIN
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,127
		cmp	byte [edx+eax*1+2097984],0
		je	NEAR ..@378
; [338] SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]:=0;
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,127
		fldz
		fstp	dword [edx+eax*4+2098000]
; [339] SynthData.RealtimeData.LinkFirst[SynthData.FileData.Link[Channel] AND $7F]:=FALSE;
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,127
		mov	byte [edx+eax*1+2097984],0
..@378:
; [341] SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]:=SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]+(OscValue*SynthData.FileData.LinkFactor[Channel]);
		mov	ecx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	edx,dword [ecx+eax*1+16]
		and	edx,127
		fld	dword [ebp-36]
		fmul	dword [ecx+eax*4+32]
		fadd	dword [ecx+edx*4+2098000]
		mov	edx,dword [ecx+eax*1+16]
		and	edx,127
		fstp	dword [ecx+edx*4+2098000]
..@376:
; [343] IF (SynthData.FileData.Link[Channel] AND $80)<>0 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,128
		je	NEAR ..@386
; [344] Value:=OscValue*SynthData.FileData.OutFactor[Channel];
		mov	eax,dword [ebp-8]
		fld	dword [ebp-36]
		fmul	dword [edx+eax*4+96]
		fstp	dword [ebp-40]
; [345] PanningValue:=SynthData.FileData.Panning[Channel]*Div255;
		movzx	eax,byte [edx+eax*1+352]
		mov	dword [ebp-56],eax
		fild	dword [ebp-56]
		fld	tword [..@391]
		fmulp	st1,st0
		fst	dword [ebp-32]
; [349] OscValue:=Value*PanningValue;
		fmul	dword [ebp-40]
		fstp	dword [ebp-36]
; [350] SynthData.RealtimeData.ChannelLastLeft[Channel]:=OscValue;
		mov	eax,dword [ebp-8]
		lea	edi,[edx+eax*4+2098256]
		lea	esi,[ebp-36]
		cld
		mov	ecx,4
		rep
		movsb
; [351] Left:=Left+OscValue;
		fld	dword [ebp-36]
		fadd	dword [ebp-24]
		fstp	dword [ebp-24]
; [352] OscValue:=Value*(1-PanningValue);
		fld	dword [ebp-40]
		fld1
		fsub	dword [ebp-32]
		fmulp	st1,st0
		fstp	dword [ebp-36]
; [353] SynthData.RealtimeData.ChannelLastRight[Channel]:=OscValue;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		lea	edi,[edx+eax*4+2098320]
		lea	esi,[ebp-36]
		cld
		mov	ecx,4
		rep
		movsb
; [354] Right:=Right+OscValue;
		fld	dword [ebp-36]
		fadd	dword [ebp-28]
		fstp	dword [ebp-28]
..@386:
; [360] SynthData.RealtimeData.Phase[Channel]:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.PhaseIncrement[Channel]);
		mov	edx,dword [ebp+8]
		mov	ecx,dword [ebp-8]
		fld	dword [edx+ecx*4+2098576]
		fadd	dword [edx+ecx*4+2098512]
		sub	esp,4
		fstp	dword [esp]
		call	NEAR SYNTH_FRAC$SINGLE
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fstp	dword [edx+eax*4+2098512]
; [361] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*SynthData.RealtimeData.PhaseFactor[Channel];
		fld	dword [edx+eax*4+2098640]
		fmul	dword [edx+eax*4+2098576]
		fstp	dword [edx+eax*4+2098576]
; [362] SynthData.RealtimeData.Volume[Channel]:=SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeFactor[Channel];
		fld	dword [edx+eax*4+2098192]
		fmul	dword [edx+eax*4+2098064]
		fstp	dword [edx+eax*4+2098064]
		cmp	eax,15
		jl	NEAR ..@184
; [364] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
		mov	eax,dword [edx+2099804]
		test	eax,eax
		jne	NEAR ..@413
; [365] IF Count=0 THEN SynthReinit(SynthData);
		mov	eax,dword [ebp-12]
		test	eax,eax
		jne	NEAR ..@415
		mov	eax,edx
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
..@415:
; [366] SynthData.RealtimeData.CurrentBPMSamples:=SynthData.RealtimeData.BPMSamples;
		mov	edx,dword [ebp+8]
		lea	edi,[edx+2099804]
		lea	esi,[edx+2099800]
		cld
		mov	ecx,4
		rep
		movsb
..@413:
; [368] DEC(SynthData.RealtimeData.CurrentBPMSamples);
		mov	eax,dword [ebp+8]
		dec	dword [eax+2099804]
; [369] Left:=Left+SynthData.RealtimeData.LastLeft;
		fld	dword [ebp-24]
		fadd	dword [eax+2099344]
		fstp	dword [ebp-24]
; [370] SynthData.RealtimeData.LastLeft:=SynthData.RealtimeData.LastLeft*0.9;
		fld	dword [eax+2099344]
		fld	tword [..@424]
		fmulp	st1,st0
		fstp	dword [eax+2099344]
; [371] Right:=Right+SynthData.RealtimeData.LastRight;
		fld	dword [ebp-28]
		fadd	dword [eax+2099348]
		fstp	dword [ebp-28]
; [372] SynthData.RealtimeData.LastRight:=SynthData.RealtimeData.LastRight*0.9;
		fld	dword [eax+2099348]
		fld	tword [..@424]
		fmulp	st1,st0
		fstp	dword [eax+2099348]
; [373] Buffer^:=Left*Div8;
		mov	eax,dword [ebp+12]
		fld	dword [ebp-24]
		fld	tword [..@431]
		fmulp	st1,st0
		fstp	dword [eax]
; [374] INC(Buffer);
		add	dword [ebp+12],4
; [375] Buffer^:=Right*Div8;
		mov	eax,dword [ebp+12]
		fld	dword [ebp-28]
		fld	tword [..@431]
		fmulp	st1,st0
		fstp	dword [eax]
; [376] INC(Buffer);
		add	dword [ebp+12],4
		mov	eax,dword [ebp-4]
		cmp	eax,dword [ebp-52]
		jl	NEAR ..@167
..@166:
; [378] END;
		mov	ebx,dword [ebp-76]
		mov	esi,dword [ebp-72]
		mov	edi,dword [ebp-68]
		leave
		ret	16
	ALIGN 4
; [381] BEGIN
	GLOBAL SYNTH_SYNTHLOAD$T4KSYNTHDATA$POINTER$LONGINT
SYNTH_SYNTHLOAD$T4KSYNTHDATA$POINTER$LONGINT:
	GLOBAL SynthLoad
SynthLoad:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para SynthData located at ebp+8
; Para TrackData located at ebp+12
; Para TrackSize located at ebp+16
; [382] FILLCHAR(SynthData,SIZEOF(T4kSynthData),#0);
		mov	cl,0
		mov	edx,2099809
		mov	eax,dword [ebp+8]
		call	NEAR SYSTEM_FILLCHAR$1$formal$LONGINT$CHAR
; [383] MOVE(TrackData^,SynthData,TrackSize);
		mov	ecx,dword [ebp+16]
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp+12]
		call	NEAR SYSTEM_MOVE$formal$formal$LONGINT
; [384] SynthInitData(SynthData);
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHINITDATA$T4KSYNTHDATA
; [385] END;
		leave
		ret	12
	ALIGN 4
; [390] BEGIN
	GLOBAL SYNTH_SYNTHINIT$T4KSYNTHDATA$POINTER$LONGINT
SYNTH_SYNTHINIT$T4KSYNTHDATA$POINTER$LONGINT:
	GLOBAL SynthInit
SynthInit:
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para SynthData located at ebp+8
; Para TrackData located at ebp+12
; Para TrackSize located at ebp+16
; Local I located at ebp-4
; [392] FLDCW cwChop
		fldcw	word [TC_SYNTH_SYNTHINIT$_CWCHOP]
; [394] SynthLoad(SynthData,TrackData,TrackSize);
		push	dword [ebp+16]
		push	dword [ebp+12]
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHLOAD$T4KSYNTHDATA$POINTER$LONGINT
; [396] WhiteNoiseSeed:=$12345678;
		mov	dword [U_SYNTH_WHITENOISESEED],305419896
; [398] waveOutOpen(@WaveOutHandle,WAVE_MAPPER,@WaveFormat,0,0,0);
		push	dword 0
		push	dword 0
		push	dword 0
		mov	eax,dword TC_SYNTH_WAVEFORMAT
		push	eax
		push	dword -1
		mov	eax,dword U_SYNTH_WAVEOUTHANDLE
		push	eax
		call	NEAR MMSYSTEM_WAVEOUTOPEN$LPHWAVEOUT$LONGWORD$LPCWAVEFORMATEX$LONGWORD$LONGWORD$LONGWORD
; [400] FOR I:=0 TO 3 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
..@474:
		inc	dword [ebp-4]
; [401] WaveHandler[I].dwFlags:=WHDR_DONE;
		mov	eax,dword [ebp-4]
		shl	eax,5
		mov	dword [U_SYNTH_WAVEHANDLER+eax+16],1
; [402] WaveHandler[I].lpData:=@Buffers[I];
		mov	eax,dword [ebp-4]
		imul	eax,32776
		lea	edx,[U_SYNTH_BUFFERS+eax]
		mov	eax,dword [ebp-4]
		shl	eax,5
		mov	dword [U_SYNTH_WAVEHANDLER+eax],edx
; [403] WaveHandler[I].dwBufferLength:=BufferSize*8;
		mov	dword [U_SYNTH_WAVEHANDLER+eax+4],32768
		cmp	dword [ebp-4],3
		jl	NEAR ..@474
; [406] BufferCounter:=0;
		mov	dword [U_SYNTH_BUFFERCOUNTER],0
; [407] END;
		leave
		ret	12
	ALIGN 4
; [410] BEGIN
	GLOBAL SYNTH_SYNTHPOLL$T4KSYNTHDATA
SYNTH_SYNTHPOLL$T4KSYNTHDATA:
	GLOBAL SynthPoll
SynthPoll:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para SynthData located at ebp+8
; [411] IF (WaveHandler[BufferCounter].dwFlags AND WHDR_DONE)<>0 THEN BEGIN
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		mov	eax,dword [U_SYNTH_WAVEHANDLER+eax+16]
		and	eax,1
		je	NEAR ..@488
; [412] IF waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR))<>WAVERR_STILLPLAYING THEN BEGIN
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTUNPREPAREHEADER$LONGWORD$LPWAVEHDR$LONGWORD
		cmp	eax,33
		je	NEAR ..@490
; [413] WaveHandler[BufferCounter].dwFlags:=WaveHandler[BufferCounter].dwFlags AND NOT WHDR_DONE;
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		and	dword [U_SYNTH_WAVEHANDLER+eax+16],-2
; [414] SynthFillBuffer(SynthData,@WaveHandler[BufferCounter].lpData^,0,BufferSize);
		push	dword 4096
		push	dword 0
		mov	eax,dword [U_SYNTH_WAVEHANDLER+eax]
		push	eax
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE$LONGINT$LONGINT
; [415] waveOutPrepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTPREPAREHEADER$LONGWORD$LPWAVEHDR$LONGWORD
; [416] waveOutWrite(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTWRITE$LONGWORD$LPWAVEHDR$LONGWORD
; [417] BufferCounter:=(BufferCounter+1) MOD 4;
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		inc	eax
		and	eax,3
		mov	dword [U_SYNTH_BUFFERCOUNTER],eax
..@490:
..@488:
; [420] END;
		leave
		ret	4
	ALIGN 4
; [426] BEGIN
	GLOBAL SYNTH_SYNTHDONE$T4KSYNTHDATA
SYNTH_SYNTHDONE$T4KSYNTHDATA:
	GLOBAL SynthDone
SynthDone:
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para SynthData located at ebp+8
; Local I located at ebp-4
; [428] FOR I:=0 TO 3 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
..@525:
		inc	dword [ebp-4]
..@528:
..@529:
; [429] WHILE waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[I],SIZEOF(TWAVEHDR))=WAVERR_STILLPLAYING DO BEGIN
		push	dword 32
		mov	eax,dword [ebp-4]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTUNPREPAREHEADER$LONGWORD$LPWAVEHDR$LONGWORD
		cmp	eax,33
		je	NEAR ..@528
..@530:
		cmp	dword [ebp-4],3
		jl	NEAR ..@525
; [432] waveOutReset(WaveOutHandle);
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTRESET$LONGWORD
; [433] waveOutClose(WaveOutHandle);
		push	dword [U_SYNTH_WAVEOUTHANDLE]
		call	NEAR MMSYSTEM_WAVEOUTCLOSE$LONGWORD
; [435] END;
		leave
		ret	4
	ALIGN 4

SECTION .data
	ALIGN 4
; [116] CONST WaveFormat:TWaveFormatEx=(wFormatTag:3;nChannels:2;nSamplesPerSec:SampleRate;
TC_SYNTH_WAVEFORMAT	DW	3,2
	DD	44100,352800
	DW	8,32,0
..@243:
		DD	..@121
		DD	..@123
		DD	..@125
		DD	..@125
		DD	..@128
		DD	..@130
		DD	..@132
		DD	..@134
		DD	..@242
		DD	..@242
		DD	..@242
		DD	..@242
		DD	..@242
		DD	..@242
		DD	..@136
		DD	..@138
		DD	..@140
		DD	..@142
..@301:
		DD	..@144
		DD	..@146
		DD	..@148
		DD	..@150
		DD	..@150
		DD	..@153
..@336:
		DD	..@155
		DD	..@157
		DD	..@159
		DD	..@161
		DD	..@163
	ALIGN 2
; [388] CONST cwChop:WORD=$F7B;
TC_SYNTH_SYNTHINIT$_CWCHOP	DW	3963
; [438] 
	GLOBAL THREADVARLIST_SYNTH
THREADVARLIST_SYNTH:
	DD	0

SECTION .data
	ALIGN 4
..@54:
		DT	 3.0000000000000000e0000
	ALIGN 4
..@101:
		DD	 9.960937500e-01
	ALIGN 4
..@114:
		DT	 8.3333333333333333e-0002
	ALIGN 4
..@117:
		DD	 2.000000000e00
	ALIGN 4
..@118:
		DT	 9.9773242630385488e-0003
	ALIGN 4
..@236:
		DT	 1.5625000000000000e-0002
	ALIGN 4
..@240:
		DT	 3.9062500000000000e-0003
	ALIGN 4
..@258:
		DT	 2.0000000000000000e0000
	ALIGN 4
..@279:
		DT	 6.2358276643990930e-0004
	ALIGN 4
..@306:
		DT	 5.0000000000000000e-0001
	ALIGN 4
..@315:
		DT	 4.0000000000000000e0000
	ALIGN 4
..@391:
		DT	 3.9215686274509804e-0003
	ALIGN 4
..@424:
		DT	 9.0000000000000000e-0001
	ALIGN 4
..@431:
		DT	 1.2500000000000000e-0001

SECTION .data
	ALIGN 4
; [14] TYPE PSINGLE=^SINGLE;
	GLOBAL RTTI__SYNTH_PSINGLE
RTTI__SYNTH_PSINGLE	DB	0
		DB	7,"PSINGLE"
	ALIGN 4
; [15] PBYTE=^BYTE;
	GLOBAL RTTI__SYNTH_PBYTE
RTTI__SYNTH_PBYTE	DB	0
		DB	5,"PBYTE"
	ALIGN 4
; [21] TYPE T4kFileData=PACKED RECORD
..@2	DB	1
		DB	4,"Byte"
	DB	1
	DD	0,255
	ALIGN 4
..@1	DB	12
		DB	0
	DD	1,16
		DD	..@2
	ALIGN 4
..@3	DB	12
		DB	0
	DD	1,16
		DD	..@2
	ALIGN 4
..@5	DB	4
		DB	6,"Single"
	DB	0
	ALIGN 4
..@4	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@6	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@7	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@8	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@9	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@10	DB	12
		DB	0
	DD	1,16
		DD	..@2
	ALIGN 4
..@12	DB	1
		DB	7,"LongInt"
	DB	4
	DD	2147483648,2147483647
	ALIGN 4
..@11	DB	12
		DB	0
	DD	4,16
		DD	..@12
	ALIGN 4
..@13	DB	12
		DB	0
	DD	4,16
		DD	..@12
	ALIGN 4
..@14	DB	12
		DB	0
	DD	4,16
		DD	..@12
	ALIGN 4
	GLOBAL RTTI__SYNTH_T4KFILEDATA
RTTI__SYNTH_T4KFILEDATA	DB	13
		DB	11,"T4kFileData"
	DD	560,11
		DD	..@1
	DD	0
		DD	..@3
	DD	16
		DD	..@4
	DD	32
		DD	..@6
	DD	96
		DD	..@7
	DD	160
		DD	..@8
	DD	224
		DD	..@9
	DD	288
		DD	..@10
	DD	352
		DD	..@11
	DD	368
		DD	..@13
	DD	432
		DD	..@14
	DD	496
	ALIGN 4
; [35] T4kFilter=PACKED RECORD
	GLOBAL RTTI__SYNTH_T4KFILTER
RTTI__SYNTH_T4KFILTER	DB	13
		DB	9,"T4kFilter"
	DD	40,10
		DD	..@5
	DD	0
		DD	..@5
	DD	4
		DD	..@5
	DD	8
		DD	..@5
	DD	12
		DD	..@5
	DD	16
		DD	..@5
	DD	20
		DD	..@5
	DD	24
		DD	..@5
	DD	28
		DD	..@5
	DD	32
		DD	..@5
	DD	36
	ALIGN 4
; [42] T4kADSRData=PACKED RECORD
..@15	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@16	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@17	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@19	DB	18
		DB	7,"Boolean"
	DB	1
	DD	0,1
	ALIGN 4
..@18	DB	12
		DB	0
	DD	1,16
		DD	..@19
	ALIGN 4
..@20	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
	GLOBAL RTTI__SYNTH_T4KADSRDATA
RTTI__SYNTH_T4KADSRDATA	DB	13
		DB	11,"T4kADSRData"
	DD	272,5
		DD	..@15
	DD	0
		DD	..@16
	DD	64
		DD	..@17
	DD	128
		DD	..@18
	DD	192
		DD	..@20
	DD	208
	ALIGN 4
; [50] T4kRealTimeData=PACKED RECORD
..@21	DB	12
		DB	0
	DD	1,16
		DD	..@19
	ALIGN 4
..@22	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@23	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@24	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@25	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@26	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@27	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@28	DB	12
		DB	0
	DD	4,16
		DD	..@12
	ALIGN 4
..@29	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@30	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@31	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@32	DB	12
		DB	0
	DD	4,16
		DD	..@5
	ALIGN 4
..@33	DB	12
		DB	0
	DD	40,16
		DD	RTTI__SYNTH_T4KFILTER
	ALIGN 4
..@34	DB	12
		DB	0
	DD	4,16
		DD	..@12
	ALIGN 4
..@35	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@36	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@37	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@38	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@39	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@40	DB	12
		DB	0
	DD	4,16
		DD	RTTI__SYNTH_PBYTE
	ALIGN 4
..@41	DB	1
		DB	8,"LongWord"
	DB	5
	DD	0,4294967295
	ALIGN 4
	GLOBAL RTTI__SYNTH_T4KREALTIMEDATA
RTTI__SYNTH_T4KREALTIMEDATA	DB	13
		DB	15,"T4kRealTimeData"
	DD	1825,25
		DD	..@21
	DD	0
		DD	..@22
	DD	16
		DD	..@23
	DD	80
		DD	..@24
	DD	144
		DD	..@25
	DD	208
		DD	..@26
	DD	272
		DD	..@27
	DD	336
		DD	..@28
	DD	400
		DD	..@29
	DD	464
		DD	..@30
	DD	528
		DD	..@31
	DD	592
		DD	..@32
	DD	656
		DD	..@33
	DD	720
		DD	..@5
	DD	1360
		DD	..@5
	DD	1364
		DD	..@34
	DD	1368
		DD	..@35
	DD	1432
		DD	..@36
	DD	1496
		DD	..@37
	DD	1560
		DD	..@38
	DD	1624
		DD	..@39
	DD	1688
		DD	..@40
	DD	1752
		DD	..@41
	DD	1816
		DD	..@41
	DD	1820
		DD	..@19
	DD	1824
	ALIGN 4
; [78] T4kEventData=ARRAY[0..$1FFFFF] OF BYTE;
	GLOBAL RTTI__SYNTH_T4KEVENTDATA
RTTI__SYNTH_T4KEVENTDATA	DB	12
		DB	12,"T4kEventData"
	DD	1,2097152
		DD	..@2
	ALIGN 4
; [84] P4kSynthData=^T4kSynthData;
	GLOBAL RTTI__SYNTH_P4KSYNTHDATA
RTTI__SYNTH_P4KSYNTHDATA	DB	0
		DB	12,"P4kSynthData"
	ALIGN 4
; [85] T4kSynthData=PACKED RECORD
	GLOBAL RTTI__SYNTH_T4KSYNTHDATA
RTTI__SYNTH_T4KSYNTHDATA	DB	13
		DB	12,"T4kSynthData"
	DD	2099809,4
		DD	RTTI__SYNTH_T4KFILEDATA
	DD	0
		DD	RTTI__SYNTH_T4KADSRDATA
	DD	560
		DD	RTTI__SYNTH_T4KEVENTDATA
	DD	832
		DD	RTTI__SYNTH_T4KREALTIMEDATA
	DD	2097984

SECTION .bss
; [120] VAR WaveOutHandle:LONGWORD;
U_SYNTH_WAVEOUTHANDLE:	RESB	4
; [121] WaveHandler:ARRAY[0..3] OF TWAVEHDR;
U_SYNTH_WAVEHANDLER:	RESB	128
; [122] BufferCounter:LONGWORD;
U_SYNTH_BUFFERCOUNTER:	RESB	4
; [123] WhiteNoiseSeed:LONGWORD;
U_SYNTH_WHITENOISESEED:	RESB	4
; [124] Buffers:ARRAY[0..3,0..BufferSize,0..1] OF SINGLE;
U_SYNTH_BUFFERS:	RESB	131104

