/* TFM Music Maker compiled data player */
/* C version for SMD                    */
/* by Alone Coder and Shiru, 20.10.07   */


void tfc_init(data);
void tfc_frame();
void tfc_play(play);
void ym2612wr(reg,val,bank);



#define YM2612_A0   0xa04000
#define YM2612_D0   0xa04001
#define YM2612_A1   0xa04002
#define YM2612_D1   0xa04003



struct {
	unsigned char *data;
	int play;
	struct {
		uint ptr;
		uint wait;
		uint freq;
		uint retblk;
		uint loopadr;
		uint rep;
	} chn[6];
} TFCP;



void ym2612wr(reg,val,bank)
uchar reg;
uchar val;
uchar bank;
{
	register uint *pz;
    register uchar *pw,*pa,*pd,rg;

	pz=(uint*)Z80_HALT;
    *pz=0x100;

    pw=(uchar*)YM2612_A0;

    if(!bank)
    {
        pa=(uchar*)YM2612_A0;
        pd=(uchar*)YM2612_D0;
    }
    else
    {
        pa=(uchar*)YM2612_A1;
        pd=(uchar*)YM2612_D1;
    }

    while(*pw&0x80);
    *pa=reg;
	while(*pw&0x80);
    *pd=val;

    *pz=0;
}



void tfc_init(data)
unsigned char *data;
{
	register uint *pz;

	pz=(uint*)Z80_HALT;
    *pz=0x100;
	pz=(uint*)Z80_RESET;
    *pz=0x100;
	pz=(uint*)Z80_HALT;
    *pz=0;

	TFCP.data=data;
	tfc_play(FALSE);
}



void tfc_frame()
{
	register uint aa,chn,rchn,bank,key,tag,off,freq,frameptr,getptr;

	if(!TFCP.play) return;

	frameptr=0;
	getptr=FALSE;

	for(chn=0;chn<6;chn++)
	{
		if(TFCP.chn[chn].wait<0xff)
		{
			TFCP.chn[chn].wait++;
			continue;
		}

		if(chn<3)
		{
			bank=0;
			key=chn;
			rchn=chn;
		}
		else
		{
			bank=1;
			key=chn+1;
			rchn=chn-3;
		}

		if(TFCP.chn[chn].rep>0)
		{
			TFCP.chn[chn].rep--;
			if(!TFCP.chn[chn].rep) TFCP.chn[chn].ptr=TFCP.chn[chn].retblk;
		}

		while(1)
		{
			tag=TFCP.data[TFCP.chn[chn].ptr++];
			switch(tag)
			{
			case 0x7e:/*01111110 begin*/
				TFCP.chn[chn].loopadr=TFCP.chn[chn].ptr;
				continue;
			case 0x7f:/*01111111 end*/
				TFCP.chn[chn].ptr=TFCP.chn[chn].loopadr;
				continue;
			case 0xd0:/*11010000 repeat block*/
				TFCP.chn[chn].rep=TFCP.data[TFCP.chn[chn].ptr++];
				off=TFCP.data[TFCP.chn[chn].ptr++]<<8;
				off+=TFCP.data[TFCP.chn[chn].ptr++];
				TFCP.chn[chn].retblk=TFCP.chn[chn].ptr;
				TFCP.chn[chn].ptr+=(int)off;
				continue;
			case 0xbf:/*10111111 use old frame data disp16*/
				off=TFCP.data[TFCP.chn[chn].ptr++]<<8;
				off+=TFCP.data[TFCP.chn[chn].ptr++];
				frameptr=TFCP.chn[chn].ptr+(int)off;
				tag=TFCP.data[frameptr++];
				break;
			case 0xff:/*11111111 use old frame data disp8*/
				off=TFCP.data[TFCP.chn[chn].ptr++]-256;
				frameptr=TFCP.chn[chn].ptr+(int)off;
				tag=TFCP.data[frameptr++];
				break;
			default:
				if(tag>=0xe0)/*skip 32..2 frames*/
				{
					TFCP.chn[chn].wait=tag;
					break;
				}
				if(tag>=0xc0)/*slide d+16*/
				{
					freq=TFCP.chn[chn].freq;
					freq=(freq&0xff00)+((freq+tag+0x30)&0xff);
					TFCP.chn[chn].freq=freq;
					ym2612wr(0xa4+rchn,freq>>8,bank);
					ym2612wr(0xa0+rchn,freq&0xff,bank);
					break;
				}
				frameptr=TFCP.chn[chn].ptr;
				getptr=TRUE;
			}

			if(frameptr)
			{
				if(tag&0xc0) ym2612wr(0x28,key,0);/*keyoff*/
				if(tag&0x01)/*freq*/
				{
					freq=TFCP.data[frameptr++]<<8;
					freq+=TFCP.data[frameptr++];
					TFCP.chn[chn].freq=freq;
					ym2612wr(0xa4+rchn,freq>>8,bank);
					ym2612wr(0xa0+rchn,freq&0xff,bank);
				}
				for(aa=0;aa<((tag>>1)&0x1f);aa++)/*0..30 regs*/
				{
					ym2612wr(TFCP.data[frameptr],TFCP.data[frameptr+1],bank);
					frameptr+=2;
				}
				if(tag&0x80) ym2612wr(0x28,0xf0|key,0);/*keyon*/

				if(getptr)
				{
					TFCP.chn[chn].ptr=frameptr;
					getptr=FALSE;
				}
				frameptr=0;
			}

			break;
		}
	}
}



void tfc_play(play)
int play;
{
	register int aa,bb,cc,pp;

	TFCP.play=play;

	if(!TFCP.play) /* mute ym2612 */
	{
		ym2612wr(0x2f,0,0); /* freq.scaler */
		ym2612wr(0x2d,0,0);
		ym2612wr(0x22,0,0); /* LFO off */
		ym2612wr(0x2b,0,0); /* DAC off */
		ym2612wr(0x27,0,0); /* CH3 normal mode */
		ym2612wr(0x27,0,1); /* CH3 normal mode */
		for(cc=0;cc<2;cc++)
		{
			for(aa=0;aa<3;aa++)
			{
				for(bb=0x30;bb<0x40;bb+=4) ym2612wr(aa+bb,0x00,cc); /* dt1/mul */
				for(bb=0x40;bb<0x50;bb+=4) ym2612wr(aa+bb,0x7f,cc); /* tl */
				for(bb=0x50;bb<0x60;bb+=4) ym2612wr(aa+bb,0x00,cc); /* rs/ar */
				for(bb=0x60;bb<0x70;bb+=4) ym2612wr(aa+bb,0x00,cc); /* am/d1r */
				for(bb=0x70;bb<0x80;bb+=4) ym2612wr(aa+bb,0x00,cc); /* d2r */
				for(bb=0x80;bb<0x90;bb+=4) ym2612wr(aa+bb,0x0f,cc); /* d1l/rr */
				for(bb=0x90;bb<0xa0;bb+=4) ym2612wr(aa+bb,0x00,cc); /* ssg-eg */
				ym2612wr(0xb0+bb,0x00,cc); /* fb/algo */
				ym2612wr(0xb4+bb,0x00,cc); /* ams/fms */
				ym2612wr(0x28,aa+(cc<<2),0); /* keyoff */
			}
		}
	}
	else
	{
		pp=10;
		for(aa=0;aa<6;aa++)
		{
			TFCP.chn[aa].ptr=TFCP.data[pp]+(TFCP.data[pp+1]<<8);
			TFCP.chn[aa].loopadr=TFCP.chn[aa].ptr;
			TFCP.chn[aa].wait=0xff;
			TFCP.chn[aa].rep=0;
			pp+=2;
		}
	}
}