;main M68K code taken from 'ASCII text demo' by Lewis AS Bassett
;www.sega-devega.net

;driver loading code partially taken from MVSTracker MD z80 driver

;10.04.07


	cpu 68000
	PADDING ON
	SUPMODE ON

	SECTION CODE


Z80_BUSREQ	equ	$a11100
Z80_RESET	equ	$a11200


	include "header.asm";



		;start player

		move.l #MusicData,d0
		jsr PlayMusic



SetupVDP:
		move.w	#$8238,		$c00004;	set plane a to $E000;
		move.w	#$8407,		$c00004;	set plane b to $E000;
		move.w	#$8560,		$c00004;	sprite table begins at $c000
		move.w	#$8c00,     $c00004;	Screen is 32x28 cells
		move.w	#$8f02, 	$c00004;   	set VDP increment register to increment one word after each write
		move.w	#$9000,		$c00004;	Plane A/B are 32x32 cells




SetPallette:

		move.l	#$c0000000,	$c00004;   	point the VDP control port to CRAM (Colour Pallette)
		lea	Colours(pc),	a4;
		move.w	#1,		d0;

LoadColours:
		move.w	(a4)+,		$c00000;
		dbra	d0, 		LoadColours;

		bra	LoadASCII;


Colours:
		dc.w	$0000;
		dc.w	$0fff;


LoadASCII:

		move.w	#$8f02,		$c00004;	reset increment register
		move.l	#$40000000,	$c00004;	point control port to VRAM
		lea	CharSet(pc),	a4;
		move.w	#$400,		d0;

LoadCharSet:
		move.w	(a4)+,		$c00000;
		dbra	d0,		LoadCharSet;

		bra	PrintMessage;


CharSet:

		binclude	"font.dat";


PrintMessage:
		move.l	#$60000003,     $c00004;	point to VRAM $E000
		lea	Message(pc),	a4;
		move.w	#$380,		d0;		move 32*28 chars, to fill whole screen!
		clr.w	d1;

DisplayMessage:
		move.b	(a4)+,		d1;
		sub.b	#$20,		d1;
		move.w	d1,		$c00000;
		dbra	d0,		DisplayMessage;

		move.w	#$8004,		$c00004
		move.w	#$8164,		$c00004


		bra	MainLoop;


Message:
;		      01234567890123456789012345678901
		dc.b "                                "; 0
		dc.b "                                "; 1
		dc.b " TFM MUSIC MAKER PLAYER FOR SMD "; 2
		dc.b "                                "; 3
		dc.b "                                "; 4
		dc.b " PLAYER CODE BY ALONE CODER     "; 5
		dc.b "                                "; 6
		dc.b " SMD PORT BY SHIRU              "; 7
		dc.b "                                "; 8
		dc.b "                                "; 9
		dc.b "                                "; 0
		dc.b "                                "; 1
		dc.b "                                "; 2
		dc.b "                                "; 3
		dc.b "                                "; 4
		dc.b "                                "; 5
		dc.b "                                "; 6
		dc.b "                                "; 7
		dc.b "                                "; 8
		dc.b "                                "; 9
		dc.b "                                "; 0
		dc.b "                                "; 1
		dc.b "                                "; 2
		dc.b "                                "; 3
		dc.b "                                "; 4
		dc.b "                                "; 5
		dc.b "                                "; 6
		dc.b "                                "; 7



MainLoop:


		bra	MainLoop;




;input: d0=addr. of music data, 0 for switch music off

PlayMusic

	move.w	#$100,Z80_BUSREQ	;busreq on
	move.w	#$100,Z80_RESET		;reset off

	lea $a01ffc,a0				;#1ffc in Z80 RAM
	move.b d0,(a0)+				;write 4-byte addr in Z80 RAM
	lsr.l #8,d0
	move.b d0,(a0)+
	lsr.l #8,d0
	move.b d0,(a0)+
	lsr.l #8,d0
	move.b d0,(a0)+

	lea     DriverZ80,a0		;copy Z80 driver to Z80 RAM
	lea     $a00000,a1
	move.l  #DriverZ80end,d0
	move.l  #DriverZ80,d1
	sub.l   d1,d0
copyLoop:
	move.b  (a0)+,(a1)+
	subq.w  #1,d0
	bne copyLoop

	move.w	#$0,Z80_RESET		;reset on
	move.w	#$0,Z80_BUSREQ		;busreq off
	move.w	#$100,Z80_RESET		;reset off

	rts




Interrupt:
	rte


VBL:
	rte



HBL:
	rte


DriverZ80:
		binclude	"z80drv.bin";
DriverZ80end:

MusicData:
		binclude	"music.tfc";


	org 	$20000-2;
	dc.w	$ffff;

ROMEnd:

	ENDSECTION